<?xml version="1.0" encoding="UTF-8"?>
<!--
  Copyright 2024 IBM Corporation

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
   xmlns:dp="http://www.datapower.com/extensions"
   xmlns:json="http://www.ibm.com/xmlns/prod/2009/jsonx"
   exclude-result-prefixes="dp json"
   extension-element-prefixes="dp"
   version="1.0">
   
   <xsl:template match="/">
    <!-- verbose is provided by the rule bridge code to determine if non error messages should be logged -->
    <xsl:variable name="verbose" select="dp:variable('var://context/msRuleContext/verbose')" />

     <!-- get a JSONx representation of the JSON properties in the context variable -->
     <xsl:variable name="jsonxProperties" select="dp:stringToJSONx(dp:variable('var://context/msRuleContext/properties'))" />
     <xsl:variable name="contextVarPrefix" select="'var://context/ms-callRuleWrapper/'" />
     <xsl:for-each select="$jsonxProperties/json:object/*">
        <xsl:variable name="contextVarName" select="concat($contextVarPrefix, ./@name)" />
        <xsl:choose>
          <!-- string properties, simply set the context variable with the value of the property -->
          <xsl:when test="local-name() = 'string'">
            <xsl:if test="$verbose">
              <xsl:message dp:priority="debug" dp:type="apiconnect">Setting <xsl:value-of select="$contextVarName" /> to a value of <xsl:value-of select="."/></xsl:message>
            </xsl:if>
            <dp:set-variable name="$contextVarName" value="."/>
          </xsl:when>
          <!-- array properties will be an array of strings, the strings will be concatenated together, plus separated -->
          <xsl:when test="local-name() = 'array'">
            <xsl:variable name="plusSeparatedValues">
              <xsl:for-each select="./*">
                <xsl:value-of select="."/>
                <xsl:if test="position() != last()">
                  <xsl:value-of select="'+'"/>
                </xsl:if>
              </xsl:for-each>
            </xsl:variable>
            <xsl:if test="$verbose">
              <xsl:message dp:priority="debug" dp:type="apiconnect">Setting <xsl:value-of select="$contextVarName" /> to a value of <xsl:value-of select="$plusSeparatedValues"/></xsl:message>
            </xsl:if>
            <dp:set-variable name="$contextVarName" value="$plusSeparatedValues"/>
          </xsl:when>
        </xsl:choose>
     </xsl:for-each>
   </xsl:template>
   
</xsl:stylesheet>