<?xml version="1.0"?>
<!--
* Copyright 2024 IBM Corporation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:dp="http://www.datapower.com/extensions"
  xmlns:json="http://www.ibm.com/xmlns/prod/2009/jsonx"
  exclude-result-prefixes="dp json"
  extension-element-prefixes="dp"
  version="1.0">
  
  <xsl:output method="xml"/>

  <xsl:variable name="log-category" select="'apiconnect'" />

  <xsl:template match="/">
    <!-- Retrieves node-set containing all Policy properties -->
    <xsl:variable name="properties" select="dp:stringToJSONx(dp:variable('var://context/msRuleContext/properties'))" />

    <!-- verbose is also provided by the rule bridge code to determine if non error messages should be logged -->
    <xsl:variable name="verbose" select="dp:variable('var://context/msRuleContext/verbose')" />

    <xsl:variable name="apreq" select="/identity//kerberos-apreq[1]"/>

    <!-- get required properties for validation -->
    <xsl:variable name="key-info" select="concat('keytabname:',$properties/json:object/json:string[@name = 'KeyInfo'])"/>
    <xsl:variable name="server-principal" select="string($properties/json:object/json:string[@name = 'ServerPrincipal'])"/>

    <xsl:if test="$verbose = 'true'">
      <xsl:message dp:priority="debug" dp:type="{$log-category}">
        apreq=[<xsl:value-of select="$apreq"/>], 
        key-info=[<xsl:value-of select="$key-info"/>],
        server-principal=[<xsl:value-of select="$server-principal"/>]
      </xsl:message>
    </xsl:if>

    <xsl:variable name="result">
      <xsl:copy-of select="dp:kerberos-parse-apreq($apreq, $key-info, $server-principal)"/>
    </xsl:variable>

    <xsl:choose>
    <!-- If there  is a failure, do not copy anything to the output to indicate an AU failure -->
    <xsl:when test="$result/kerberos-error">
      <xsl:message dp:priority="error" dp:type="{$log-category}">
        <xsl:copy-of select="$result"/>
      </xsl:message>
    </xsl:when>
    <xsl:otherwise>
      <xsl:copy-of select="$result"/>
    </xsl:otherwise>
  </xsl:choose>
  </xsl:template>
</xsl:stylesheet>