// Copyright 2023 IBM Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

let hm = require('header-metadata');
let sm = require('service-metadata');

switch (sm.errorSubcode) {
case '0x01d30002':
  hm.current.statusCode = '401 Unauthorized';
  break;
default:
  hm.current.statusCode = '500 Internal Server Error';
  break;
}
session.reject(sm.errorMessage);