# oauth-ratelimit
Sample to implement a rate limit for OAuth on the API Gateway

This sample has 2 main components
 - A gateway extension to configure a rate limit at the gateway scope
 - A customized preflow for the API Gateway to use the rate limit configured above

This sample works by adding a check (a `switch` policy) to the preflow to determine if the current call to the API Gateway is to satisfy an API request or if it is for an OAuth service. If the call is for an OAuth service then the API Properties will include a property named `__autogenerated_oauth_api__`, which is set to `true`. If the request is for a non-OAuth API call then the property will be absent. 

The `switch` policy uses this information to route non-OAuth calls to a ratelimit policy with `source` set to `plan-default`, which is the same policy that would be used for an API call without this sample, or to a ratelimit policy with the `source` set to `catalog-named` and the `name` set to `oauth-rate-limit` as configured by the extension. 

The main difference implemented by this sample is that the OAuth related calls now have the opportunity to drive a pre-configured ratelimit policy, whereas before this change the OAuth calls did not drive a ratelimit because OAuth configuration is not mapped to a plan. 

For more informaton about customizing the preflow for an API Gateway, please read here<br/>
https://www.ibm.com/docs/nl/api-connect/10.0.1.x?topic=policies-customizing-preflow

For more information about gateway estensions read here:<br/>
https://www.ibm.com/docs/en/api-connect/10.0.1.x?topic=behavior-configuring-your-gateway-server-extensions <br/>
https://www.ibm.com/docs/en/api-connect/10.0.1.x?topic=behavior-gateway-extension-guidelines-datapower-api-gateway

If you use have a gateway extension with a manifest, read here:<br/>
https://www.ibm.com/docs/en/api-connect/10.0.1.x?topic=gateway-extensions-manifest


## Prequisites

    - IBM Datapower Firmware version 10.0.1.6
      - The __autogenerated_oauth_api__ property is set by DataPower starting with firmware version 10.0.1.6
      - The __autogenerated_oauth_api__ property is not set by any DataPower CD deliverables or prior firmware versions

