<?xml version="1.0" encoding="UTF-8"?>
<!--
  Copyright 2024 IBM Corporation

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
   xmlns:dp="http://www.datapower.com/extensions"
   xmlns:json="http://www.ibm.com/xmlns/prod/2009/jsonx"
   exclude-result-prefixes="dp json"
   extension-element-prefixes="dp"
   version="1.0">

   <!-- <xsl:output method="xml" indent="yes"/> -->

   <xsl:template match="/">
     <!-- verbose is provided by the rule bridge code to determine if non error messages should be logged -->
     <xsl:variable name="verbose" select="dp:variable('var://context/msRuleContext/verbose')" />

     <!-- get a JSONx representation of the JSON properties in the context variable -->
     <xsl:variable name="jsonxProperties" select="dp:stringToJSONx(dp:variable('var://context/msRuleContext/properties'))" />
     <dp:dump-nodes file="'helloworld-properties.xml'" nodes="$jsonxProperties" />
     <xsl:message dp:priority="debug">helloworld.xsl properties=<xsl:value-of select="dp:variable('var://context/msRuleContext/properties')"/></xsl:message>
     <xsl:variable name="helloValue" select="$jsonxProperties/json:object/json:string[@name = 'name']"/>

     <xsl:if test="$verbose = 'true'">
       <xsl:message dp:priority="debug">helloworld.xsl says hello to <xsl:value-of select="$helloValue"/>!!!</xsl:message>
     </xsl:if>

     <!-- output our hello world xml document -->
     <hello><xsl:value-of select="$helloValue"/></hello>

     <!-- set content-type header to match the output of this xsl -->
     <dp:set-http-response-header name="'Content-Type'" value="'application/xml'"/>
   </xsl:template>

</xsl:stylesheet>